# Entity Relationship Diagram (ERD)
## نظام إدارة رموز QR الديناميكية

## العلاقات بين الجداول

```
┌─────────────────┐
│    branches     │
├─────────────────┤
│ id (PK)         │
│ name            │
│ code (UNIQUE)   │
│ address         │
│ phone           │
│ email           │
│ is_active       │
└────────┬────────┘
         │
         │ 1:N
         │
         ├──────────────────┐
         │                  │
         ▼                  ▼
┌─────────────────┐  ┌─────────────────┐
│  departments    │  │     users       │
├─────────────────┤  ├─────────────────┤
│ id (PK)         │  │ id (PK)         │
│ branch_id (FK)  │  │ branch_id (FK)  │
│ name            │  │ department_id   │
│ code            │  │ role_id (FK)    │
│ description     │  │ username        │
│ is_active       │  │ email           │
└────────┬────────┘  │ password        │
         │           │ full_name       │
         │ 1:N       │ is_active       │
         │           │ last_login      │
         │           └────────┬────────┘
         │                    │
         └────────────────────┘
                    │
                    │ N:1
                    ▼
         ┌─────────────────┐
         │     roles       │
         ├─────────────────┤
         │ id (PK)         │
         │ name (UNIQUE)   │
         │ display_name    │
         │ permissions     │
         └─────────────────┘

┌─────────────────┐
│    branches     │
├─────────────────┤
│ id (PK)         │
└────────┬────────┘
         │
         │ 1:N
         │
         ├──────────────────┐
         │                  │
         ▼                  ▼
┌─────────────────┐  ┌─────────────────┐
│    products     │  │   warehouses    │
├─────────────────┤  ├─────────────────┤
│ id (PK)         │  │ id (PK)         │
│ branch_id (FK)  │  │ branch_id (FK)  │
│ sku             │  │ code            │
│ name            │  │ name            │
│ model           │  │ location        │
│ type            │  │ area            │
│ description     │  │ rack            │
│ datasheet_pdf   │  │ zone            │
│ catalog_pdf     │  │ is_active       │
│ specifications  │  └────────┬────────┘
│ is_active       │           │
└────────┬────────┘           │ 1:N
         │                    │
         │ N:1                ▼
         │          ┌─────────────────┐
         │          │   inventory     │
         │          ├─────────────────┤
         │          │ id (PK)         │
         │          │ warehouse_id(FK)│
         │          │ product_id (FK) │
         │          │ quantity        │
         │          │ min_threshold   │
         │          │ status          │
         │          └─────────────────┘
         │
         │ N:1
         ▼
┌─────────────────┐
│    projects     │
├─────────────────┤
│ id (PK)         │
│ branch_id (FK)  │
│ name            │
│ code            │
│ type            │
│ start_date      │
│ end_date        │
│ is_active       │
└─────────────────┘

┌─────────────────┐
│    qr_codes     │
├─────────────────┤
│ id (PK)         │
│ short_code(UNIQ)│
│ branch_id (FK)  │
│ department_id   │
│ project_id (FK) │
│ product_id (FK) │
│ warehouse_id(FK)│
│ title           │
│ description     │
│ target_type     │
│ target_url      │
│ redirect_rules  │
│ is_active       │
│ password_protect│
│ password_hash   │
│ expires_at      │
│ scan_limit      │
│ scan_count      │
│ created_by (FK) │
└────────┬────────┘
         │
         │ 1:N
         │
         ├──────────────────────┐
         │                      │
         ▼                      ▼
┌─────────────────┐    ┌─────────────────┐
│   qr_scans      │    │  audit_logs     │
├─────────────────┤    ├─────────────────┤
│ id (PK)         │    │ id (PK)         │
│ qr_code_id (FK) │    │ user_id (FK)    │
│ ip_address      │    │ action          │
│ user_agent      │    │ entity_type     │
│ device_type     │    │ entity_id       │
│ country         │    │ old_values      │
│ city            │    │ new_values      │
│ latitude        │    │ ip_address      │
│ longitude       │    │ user_agent      │
│ scanned_at      │    │ created_at      │
└─────────────────┘    └─────────────────┘

┌─────────────────┐
│   inventory     │
├─────────────────┤
│ id (PK)         │
│ warehouse_id(FK)│
│ product_id (FK) │
└────────┬────────┘
         │
         │ 1:N
         │
         ▼
┌─────────────────┐
│inventory_alerts │
├─────────────────┤
│ id (PK)         │
│ inventory_id(FK)│
│ warehouse_id(FK)│
│ product_id (FK) │
│ alert_type      │
│ message         │
│ is_resolved     │
│ resolved_by (FK)│
│ resolved_at     │
└─────────────────┘
```

## ملخص العلاقات

### الفروع (Branches)
- **له علاقة 1:N مع:**
  - Departments (أقسام)
  - Users (مستخدمون)
  - Products (منتجات)
  - Warehouses (مخازن)
  - Projects (مشاريع)

### المستخدمون (Users)
- **علاقة N:1 مع:**
  - Branches (فرع)
  - Departments (قسم)
  - Roles (دور)

### المنتجات (Products)
- **علاقة N:1 مع:**
  - Branches (فرع)
- **مرتبط بـ:**
  - QR Codes (رموز QR)
  - Inventory (مخزون)

### المخازن (Warehouses)
- **علاقة N:1 مع:**
  - Branches (فرع)
- **مرتبط بـ:**
  - Inventory (مخزون)
  - QR Codes (رموز QR)

### رموز QR (QR Codes)
- **مرتبط بـ:**
  - Branches (فرع)
  - Departments (قسم)
  - Projects (مشروع)
  - Products (منتج)
  - Warehouses (مخزن)
  - Users (منشئ)
- **له علاقة 1:N مع:**
  - QR Scans (مسحات)

### المخزون (Inventory)
- **مرتبط بـ:**
  - Warehouses (مخزن)
  - Products (منتج)
- **له علاقة 1:N مع:**
  - Inventory Alerts (تنبيهات)

### المسحات (QR Scans)
- **علاقة N:1 مع:**
  - QR Codes (رمز QR)

### سجلات المراجعة (Audit Logs)
- **علاقة N:1 مع:**
  - Users (مستخدم)

## الفهرس (Indexes)

### Primary Keys (PK)
- جميع الجداول تحتوي على `id` كـ Primary Key

### Foreign Keys (FK)
- جميع العلاقات محمية بـ Foreign Keys مع ON DELETE RESTRICT أو SET NULL حسب الحاجة

### Unique Constraints
- `branches.code`
- `users.username`
- `users.email`
- `roles.name`
- `qr_codes.short_code`
- `products.sku` (مفرد لكل فرع)

### Indexes للأداء
- جميع Foreign Keys مفهرسة
- `qr_codes.is_active`
- `qr_codes.expires_at`
- `qr_scans.scanned_at`
- `qr_scans.country`
- `qr_scans.device_type`

---

**ملاحظة:** جميع الجداول تستخدم UTF8MB4 للتأكد من دعم الأحرف العربية والرموز الخاصة بشكل صحيح.
