# دليل التثبيت الكامل

## المتطلبات الأساسية

### متطلبات الخادم
- PHP 8.0 أو أحدث
- MySQL 5.7+ أو MariaDB 10.2+
- Apache مع mod_rewrite أو Nginx
- Composer (للتبعيات)
- cPanel (اختياري)

### ملحقات PHP المطلوبة
- PDO
- PDO_MySQL
- mbstring
- json
- fileinfo
- GD أو Imagick (لتوليد صور QR)

## خطوات التثبيت

### الخطوة 1: رفع الملفات

#### عبر cPanel File Manager:
1. سجل الدخول إلى cPanel
2. افتح File Manager
3. انتقل إلى `public_html` (أو المجلد المطلوب)
4. قم بإنشاء مجلد جديد باسم `qr` (أو الاسم المطلوب)
5. ارفع جميع ملفات المشروع إلى هذا المجلد
6. تأكد من أن الملفات محفوظة بحقوق الوصول الصحيحة

#### عبر FTP:
```bash
# الاتصال عبر FTP
ftp yourdomain.com

# رفع الملفات
put -R QR/* /public_html/qr/
```

### الخطوة 2: تثبيت Composer Dependencies

#### عبر cPanel Terminal:
```bash
cd public_html/qr
php composer.phar install
```

#### عبر SSH:
```bash
cd /home/username/public_html/qr
composer install
```

### الخطوة 3: إعداد قاعدة البيانات

1. سجل الدخول إلى cPanel
2. افتح "MySQL Databases"
3. أنشئ قاعدة بيانات جديدة (مثلاً: `qr_system`)
4. أنشئ مستخدم قاعدة بيانات جديد
5. اربط المستخدم بقاعدة البيانات مع صلاحيات كاملة

**ملاحظة:** احفظ اسم المستخدم واسم قاعدة البيانات وكلمة المرور

### الخطوة 4: تشغيل Installer

1. افتح المتصفح وانتقل إلى:
   ```
   https://yourdomain.com/qr/install/install.php
   ```

2. أدخل المعلومات المطلوبة:
   - **اسم الخادم:** عادة `localhost` (أو `localhost:3306`)
   - **اسم قاعدة البيانات:** اسم قاعدة البيانات التي أنشأتها
   - **اسم المستخدم:** اسم مستخدم قاعدة البيانات
   - **كلمة المرور:** كلمة مرور قاعدة البيانات
   - **رابط الموقع:** `https://yourdomain.com/qr`

3. اضغط "بدء التثبيت"

4. إذا تم التثبيت بنجاح، ستظهر رسالة نجاح

### الخطوة 5: إعداد الملفات والمجلدات

تأكد من أن المجلدات التالية موجودة ولها صلاحيات الكتابة:

```bash
uploads/
uploads/qr_codes/
uploads/products/
uploads/datasheets/
```

**إعداد الصلاحيات:**
```bash
chmod 755 uploads
chmod 755 uploads/qr_codes
chmod 755 uploads/products
chmod 755 uploads/datasheets
```

### الخطوة 6: إعداد .htaccess

تأكد من أن ملف `.htaccess` موجود في المجلد الرئيسي.

إذا كنت تستخدم Nginx بدلاً من Apache، أضف القواعد التالية إلى إعدادات Nginx:

```nginx
location /qr {
    try_files $uri $uri/ /qr/index.php?$query_string;
}

location ~ /qr/r/([A-Z0-9]+)$ {
    rewrite ^/qr/r/(.*)$ /qr/redirect.php?code=$1 last;
}
```

### الخطوة 7: تسجيل الدخول الأول

1. انتقل إلى:
   ```
   https://yourdomain.com/qr/login.php
   ```

2. استخدم البيانات الافتراضية:
   - **اسم المستخدم:** `admin`
   - **كلمة المرور:** `admin123`

3. ⚠️ **مهم جداً:** قم بتغيير كلمة المرور فوراً!

## التحقق من التثبيت

### 1. التحقق من قاعدة البيانات
- تأكد من وجود جميع الجداول
- تأكد من وجود المستخدم الافتراضي `admin`

### 2. التحقق من الملفات
- تأكد من وجود جميع المجلدات
- تأكد من صلاحيات الكتابة على مجلد `uploads`

### 3. اختبار النظام
- قم بتسجيل الدخول
- أنشئ رمز QR تجريبي
- اختبر المسح والـ Redirect

## استكشاف الأخطاء

### خطأ في الاتصال بقاعدة البيانات
- تحقق من اسم المستخدم وكلمة المرور
- تحقق من أن قاعدة البيانات موجودة
- تحقق من أن المستخدم لديه صلاحيات على قاعدة البيانات

### خطأ في إنشاء رموز QR
- تحقق من أن مكتبة GD أو Imagick مثبتة
- تحقق من صلاحيات الكتابة على مجلد `uploads/qr_codes`

### خطأ 404 في الصفحات
- تحقق من إعدادات mod_rewrite
- تحقق من ملف `.htaccess`
- تحقق من إعدادات Apache

### مشاكل الجلسات (Sessions)
- تحقق من صلاحيات الكتابة على مجلد الجلسات
- تحقق من إعدادات `session.save_path` في `php.ini`

## الأمان بعد التثبيت

### 1. حذف مجلد Install
```bash
rm -rf install/
```

أو احذفه عبر File Manager

### 2. تغيير كلمة مرور Admin
1. سجل الدخول
2. انتقل إلى إعدادات المستخدم
3. قم بتغيير كلمة المرور

### 3. إعداد HTTPS
- قم بتفعيل SSL Certificate
- حدث ملف `.htaccess` لإجبار HTTPS

### 4. تقييد الوصول
- أضف IP Whitelist (إن أمكن)
- قم بتعطيل التسجيل العام (لا يوجد في هذا النظام)

## النسخ الاحتياطي

### قاعدة البيانات
```bash
mysqldump -u username -p database_name > backup.sql
```

### الملفات
```bash
tar -czf qr_backup.tar.gz qr/
```

## التحديثات المستقبلية

عند التحديث:
1. قم بعمل نسخة احتياطية
2. ارفع الملفات الجديدة
3. قم بتشغيل أي migrations إذا لزم الأمر

## الدعم

للحصول على المساعدة، يرجى التواصل مع فريق التطوير.

---

**آخر تحديث:** 2024
