# نظام إدارة رموز QR الديناميكية

نظام داخلي متكامل لإدارة رموز QR الديناميكية مخصص للاستخدام الداخلي في الشركات. تم بناؤه باستخدام PHP 8.x و MySQL و JavaScript.

## المميزات الرئيسية

### 🔐 نظام الأمان والصلاحيات (RBAC)
- مستويات صلاحيات متعددة (Super Admin, Admin, Manager, Staff, Viewer)
- تقييد الوصول حسب الفرع والقسم
- تسجيل كامل لجميع العمليات (Audit Log)
- حماية من CSRF, XSS, SQL Injection

### 📱 إدارة رموز QR الديناميكية
- إنشاء رموز QR ديناميكية
- رموز URL قصيرة داخلية
- تعديل المحتوى بدون إعادة طباعة QR
- تفعيل/إيقاف الرموز
- حماية بكلمة مرور أو PIN
- تاريخ انتهاء اختياري
- حد أقصى لعدد المسحات
- إنشاء جماعي (Bulk Creation)

### 🏢 الهيكل التنظيمي
- إدارة الفروع المتعددة
- إدارة الأقسام (مبيعات، مخازن، صيانة، إدارة)
- إدارة المشاريع/الحملات
- ربط كل QR بمنتج، فرع، قسم، ومشروع

### 📦 إدارة المنتجات
- إدارة كاملة للمنتجات (Motors, Gearboxes)
- ربط ملفات PDF (Datasheets, Catalogs)
- تعليمات التركيب والتشغيل
- تحذيرات السلامة
- فيديوهات تشغيل

### 🏭 إدارة المخازن
- إدارة مواقع التخزين
- تتبع المخزون
- تنبيهات نقص المخزون
- تقارير الحركة

### 📊 التقارير والتحليلات
- لوحة معلومات شاملة
- إحصائيات المسحات
- تتبع حسب الدولة ونوع الجهاز
- تقارير قابلة للتصدير
- رسوم بيانية تفاعلية

## المتطلبات التقنية

- PHP 8.0 أو أحدث
- MySQL 5.7 أو أحدث (أو MariaDB 10.2+)
- Apache مع mod_rewrite (أو Nginx)
- Composer
- cPanel (اختياري)

## التثبيت

### 1. رفع الملفات
قم برفع جميع ملفات المشروع إلى الخادم (cPanel File Manager أو FTP).

### 2. تثبيت Dependencies
```bash
composer install
```

### 3. تشغيل Installer
افتح المتصفح وانتقل إلى:
```
https://yourdomain.com/install/install.php
```

أدخل:
- معلومات قاعدة البيانات
- رابط الموقع الأساسي

### 4. بيانات تسجيل الدخول الافتراضية
- **اسم المستخدم:** admin
- **كلمة المرور:** admin123

⚠️ **مهم جداً:** قم بتغيير كلمة المرور فوراً بعد تسجيل الدخول!

## هيكل المشروع

```
QR/
├── assets/              # CSS, JS, Images
├── config/              # ملفات التكوين
│   ├── app.php
│   └── database.php
├── core/                # Core Classes
│   ├── Auth.php         # نظام المصادقة
│   ├── Database.php     # إدارة قاعدة البيانات
│   ├── QRCode.php       # إدارة رموز QR
│   └── Security.php     # أدوات الأمان
├── database/            # ملفات قاعدة البيانات
│   └── schema.sql
├── includes/            # Templates
│   ├── header.php
│   └── footer.php
├── install/             # ملفات التثبيت
│   └── install.php
├── products/            # إدارة المنتجات
├── qr/                  # إدارة رموز QR
├── reports/             # التقارير
├── uploads/             # الملفات المرفوعة
├── warehouses/          # إدارة المخازن
├── .htaccess           # Apache Configuration
├── composer.json       # PHP Dependencies
├── index.php           # Dashboard
├── login.php           # صفحة تسجيل الدخول
├── redirect.php        # QR Redirect Handler
└── README.md           # هذا الملف
```

## الاستخدام

### إنشاء رمز QR جديد
1. انتقل إلى "رموز QR" > "إنشاء جديد"
2. اختر المنتج أو المخزن المراد ربطه
3. حدد نوع الهدف
4. (اختياري) أضف حماية بكلمة مرور
5. اضغط "إنشاء"

### إدارة المنتجات
- إضافة منتجات جديدة مع ملفات PDF ومواصفات
- ربط المنتجات برموز QR
- تتبع المنتجات حسب الفرع

### إدارة المخازن
- إضافة مواقع تخزين جديدة
- تتبع المخزون
- استقبال تنبيهات نقص المخزون

### التقارير
- عرض إحصائيات شاملة
- تتبع المسحات حسب التاريخ
- تحليل حسب نوع الجهاز والدولة

## الأمان

النظام يشمل:
- ✅ حماية CSRF
- ✅ حماية XSS
- ✅ Prepared Statements (SQL Injection Protection)
- ✅ Password Hashing (bcrypt)
- ✅ Session Security
- ✅ Login Attempts Limiting
- ✅ File Upload Validation

## الدعم والمساعدة

للمساعدة والدعم الفني، يرجى التواصل مع فريق التطوير.

## الترخيص

هذا النظام مملوك للشركة ويستخدم داخلياً فقط. لا يُسمح بنسخه أو توزيعه خارج الشركة.

---

**الإصدار:** 1.0.0  
**تاريخ الإصدار:** 2024
