<?php
/**
 * Application Configuration
 */

return [
    'app_name' => 'QR Code Management System',
    'app_version' => '1.0.0',
    'company_name' => 'Company Name',
    'company_logo' => 'assets/img/logo.png',
    
    'base_url' => getenv('BASE_URL') ?: 'http://localhost',
    'timezone' => 'Africa/Cairo',
    'locale' => 'ar',
    
    'session' => [
        'lifetime' => 7200, // 2 hours
        'name' => 'QR_SESSION',
        'secure' => false,
        'httponly' => true
    ],
    
    'security' => [
        'csrf_token_name' => '_token',
        'password_min_length' => 8,
        'login_attempts' => 5,
        'lockout_duration' => 900 // 15 minutes
    ],
    
    'qr' => [
        'default_redirect' => '/',
        'short_url_length' => 8,
        'expiry_check_enabled' => true,
        'scan_tracking_enabled' => true
    ],
    
    'paths' => [
        'uploads' => __DIR__ . '/../uploads/',
        'qr_codes' => __DIR__ . '/../uploads/qr_codes/',
        'products' => __DIR__ . '/../uploads/products/',
        'datasheets' => __DIR__ . '/../uploads/datasheets/'
    ],
    
    'permissions' => [
        'roles' => ['super_admin', 'admin', 'manager', 'staff', 'viewer']
    ]
];
