<?php
/**
 * Simple Autoloader
 */

spl_autoload_register(function ($class) {
    $prefix = 'Core\\';
    $baseDir = __DIR__ . '/';
    
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    $relativeClass = substr($class, $len);
    $file = $baseDir . str_replace('\\', '/', $relativeClass) . '.php';
    
    if (file_exists($file)) {
        require $file;
    }
});

// Load Helpers
require_once __DIR__ . '/Helpers.php';

// Load app config and set timezone (only once)
if (!defined('APP_CONFIG_LOADED')) {
    define('APP_CONFIG_LOADED', true);
    $config = require __DIR__ . '/../config/app.php';
    date_default_timezone_set($config['timezone'] ?? 'UTC');
}
