<?php
/**
 * Helper Functions
 */

namespace Core;

class Helpers {
    /**
     * Get base URL for the application
     */
    public static function baseUrl($path = '') {
        $config = require __DIR__ . '/../config/app.php';
        
        // If base_url is set in config, use it
        if (!empty($config['base_url']) && $config['base_url'] !== 'http://localhost') {
            $baseUrl = rtrim($config['base_url'], '/');
        } else {
            // Auto-detect base URL
            $protocol = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
            $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
            
            // Get script name and directory
            $scriptName = $_SERVER['SCRIPT_NAME'] ?? $_SERVER['PHP_SELF'] ?? '';
            
            // Calculate base path
            // If script is in a subdirectory, include it
            $scriptDir = dirname($scriptName);
            
            // Normalize path
            if ($scriptDir === '/' || $scriptDir === '\\' || $scriptDir === '.') {
                $scriptDir = '';
            }
            
            // Remove 'core' from path if it exists
            $scriptDir = preg_replace('/\/core$/', '', $scriptDir);
            
            $baseUrl = $protocol . '://' . $host . $scriptDir;
            $baseUrl = rtrim($baseUrl, '/');
        }
        
        if (!empty($path)) {
            $path = ltrim($path, '/');
            return $baseUrl . '/' . $path;
        }
        
        return $baseUrl;
    }
    
    /**
     * Get relative URL (for links within the application)
     */
    public static function url($path = '') {
        // Get script directory
        $scriptName = $_SERVER['SCRIPT_NAME'] ?? '';
        $scriptDir = dirname($scriptName);
        
        // If script is in root, remove the directory
        if ($scriptDir === '/' || $scriptDir === '\\') {
            $basePath = '';
        } else {
            $basePath = $scriptDir;
        }
        
        // Remove trailing slash
        $basePath = rtrim($basePath, '/');
        
        // Handle relative paths
        if (empty($path)) {
            return $basePath ?: '.';
        }
        
        $path = ltrim($path, '/');
        
        // If path starts with ./, return as is
        if (strpos($path, './') === 0 || strpos($path, '../') === 0) {
            return $path;
        }
        
        return $basePath . '/' . $path;
    }
    
    /**
     * Get asset URL
     */
    public static function asset($path) {
        return self::url('assets/' . ltrim($path, '/'));
    }
    
    /**
     * Redirect helper
     */
    public static function redirect($path, $permanent = false) {
        $url = self::url($path);
        header('Location: ' . $url, true, $permanent ? 301 : 302);
        exit;
    }
}
