<?php
require_once __DIR__ . '/core/Autoloader.php';
$type = $_GET['type'] ?? 'unknown';
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>خطأ - QR Code</title>
    <link rel="stylesheet" href="<?= Core\Helpers::asset('css/style.css') ?>">
</head>
<body>
    <div class="main-content" style="text-align: center; padding: 4rem 1rem;">
        <?php if ($type === 'expired'): ?>
            <h1 style="color: #ffc107; margin-bottom: 1rem;">⏰</h1>
            <h2>رمز QR منتهي الصلاحية</h2>
            <p>عذراً، هذا الرمز QR قد انتهت صلاحيته.</p>
        <?php elseif ($type === 'disabled'): ?>
            <h1 style="color: #dc3545; margin-bottom: 1rem;">🚫</h1>
            <h2>رمز QR معطل</h2>
            <p>عذراً، هذا الرمز QR غير نشط حالياً.</p>
        <?php elseif ($type === 'limit_reached'): ?>
            <h1 style="color: #dc3545; margin-bottom: 1rem;">📊</h1>
            <h2>تم الوصول للحد الأقصى</h2>
            <p>عذراً، تم الوصول للحد الأقصى لعدد المسحات المسموح بها.</p>
        <?php else: ?>
            <h1 style="color: #dc3545; margin-bottom: 1rem;">❌</h1>
            <h2>حدث خطأ</h2>
            <p>عذراً، حدث خطأ أثناء معالجة طلبك.</p>
        <?php endif; ?>
    </div>
</body>
</html>
