<?php
/**
 * Fix Admin Password - Web Interface
 * Open this file in browser to reset admin password
 */

// Prevent direct access if already fixed
if (file_exists(__DIR__ . '/.password_fixed')) {
    die('Password has already been reset. Delete .password_fixed file to reset again.');
}

require_once __DIR__ . '/core/Autoloader.php';

use Core\Database;
use Core\Security;

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $newPassword = $_POST['password'] ?? '';
    $confirmPassword = $_POST['confirm_password'] ?? '';
    
    if (empty($newPassword)) {
        $error = 'كلمة المرور مطلوبة';
    } elseif (strlen($newPassword) < 8) {
        $error = 'كلمة المرور يجب أن تكون 8 أحرف على الأقل';
    } elseif ($newPassword !== $confirmPassword) {
        $error = 'كلمة المرور غير متطابقة';
    } else {
        try {
            $db = Database::getInstance();
            $passwordHash = Security::hashPassword($newPassword);
            
            $db->query(
                "UPDATE users SET password = ?, login_attempts = 0, locked_until = NULL WHERE username = 'admin'",
                [$passwordHash]
            );
            
            // Create flag file
            file_put_contents(__DIR__ . '/.password_fixed', date('Y-m-d H:i:s'));
            
            $success = '✅ تم تحديث كلمة المرور بنجاح! يمكنك الآن تسجيل الدخول.';
        } catch (Exception $e) {
            $error = 'خطأ: ' . $e->getMessage();
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>إعادة تعيين كلمة المرور</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 40px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            max-width: 400px;
            width: 100%;
        }
        h1 {
            color: #007bff;
            margin-top: 0;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input[type="password"] {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 16px;
            box-sizing: border-box;
        }
        button {
            width: 100%;
            padding: 12px;
            background: #007bff;
            color: white;
            border: none;
            border-radius: 4px;
            font-size: 16px;
            cursor: pointer;
        }
        button:hover {
            background: #0056b3;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
            font-size: 14px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>إعادة تعيين كلمة المرور</h1>
        
        <div class="info">
            <strong>مستخدم:</strong> admin<br>
            قم بإدخال كلمة مرور جديدة للمستخدم admin
        </div>
        
        <?php if ($error): ?>
            <div class="error"><?= htmlspecialchars($error) ?></div>
        <?php endif; ?>
        
        <?php if ($success): ?>
            <div class="success"><?= htmlspecialchars($success) ?></div>
            <p><a href="<?= Core\Helpers::url('login.php') ?>">اضغط هنا لتسجيل الدخول</a></p>
        <?php else: ?>
            <form method="POST">
                <div class="form-group">
                    <label for="password">كلمة المرور الجديدة:</label>
                    <input type="password" id="password" name="password" required minlength="8">
                </div>
                
                <div class="form-group">
                    <label for="confirm_password">تأكيد كلمة المرور:</label>
                    <input type="password" id="confirm_password" name="confirm_password" required minlength="8">
                </div>
                
                <button type="submit">تحديث كلمة المرور</button>
            </form>
        <?php endif; ?>
    </div>
</body>
</html>
