<?php
/**
 * Header Template
 */

use Core\Auth;
use Core\Security;

$auth = new Auth();
$user = $auth->user();

if (!isset($pageTitle)) {
    $pageTitle = 'نظام إدارة رموز QR';
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= Security::sanitizeOutput($pageTitle) ?> - نظام إدارة رموز QR</title>
    <link rel="stylesheet" href="<?= Core\Helpers::asset('css/style.css') ?>">
</head>
<body>
    <?php if ($auth->check()): ?>
    <nav class="navbar">
        <div class="nav-container">
            <div class="nav-brand">
                <h2>نظام إدارة رموز QR</h2>
            </div>
            <ul class="nav-menu">
                <li><a href="<?= Core\Helpers::url('index.php') ?>">الرئيسية</a></li>
                <?php if ($auth->hasPermission('qr.view')): ?>
                    <li><a href="<?= Core\Helpers::url('qr/list.php') ?>">رموز QR</a></li>
                <?php endif; ?>
                <?php if ($auth->hasPermission('products.view')): ?>
                    <li><a href="<?= Core\Helpers::url('products/manage.php') ?>">المنتجات</a></li>
                <?php endif; ?>
                <?php if ($auth->hasPermission('warehouses.view')): ?>
                    <li><a href="<?= Core\Helpers::url('warehouses/manage.php') ?>">المخازن</a></li>
                <?php endif; ?>
                <?php if ($auth->hasPermission('reports.view')): ?>
                    <li><a href="<?= Core\Helpers::url('reports/dashboard.php') ?>">التقارير</a></li>
                <?php endif; ?>
                <?php if ($auth->hasPermission('*')): ?>
                    <li><a href="<?= Core\Helpers::url('admin/settings.php') ?>">الإعدادات</a></li>
                <?php endif; ?>
            </ul>
            <div class="nav-user">
                <span><?= Security::sanitizeOutput($user['full_name']) ?></span>
                <a href="<?= Core\Helpers::url('logout.php') ?>" class="btn btn-sm btn-secondary">تسجيل الخروج</a>
            </div>
        </div>
    </nav>
    <?php endif; ?>
    
    <main class="main-content">
