<?php
/**
 * Main Entry Point - Dashboard
 */

require_once __DIR__ . '/core/Autoloader.php';

use Core\Auth;
use Core\QRCode;
use Core\Security;

$auth = new Auth();
$auth->requireAuth();

$user = $auth->user();
$qrHandler = new QRCode();

// Get statistics
$stats = $qrHandler->getStatistics(['branch_id' => $user['branch_id']]);

// Get recent QR codes
$recentQRCodes = $qrHandler->list(['branch_id' => $user['branch_id']], 1, 10);

$pageTitle = 'لوحة التحكم';
include 'includes/header.php';
?>

<div class="dashboard">
    <h1>مرحباً <?= Security::sanitizeOutput($user['full_name']) ?></h1>
    
    <!-- Statistics Cards -->
    <div class="stats-grid">
        <div class="stat-card">
            <div class="stat-icon">📊</div>
            <div class="stat-content">
                <h3><?= number_format($stats['total_qr_codes'] ?? 0) ?></h3>
                <p>إجمالي رموز QR</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">✓</div>
            <div class="stat-content">
                <h3><?= number_format($stats['active_qr_codes'] ?? 0) ?></h3>
                <p>رموز QR نشطة</p>
            </div>
        </div>
        
        <div class="stat-card">
            <div class="stat-icon">📱</div>
            <div class="stat-content">
                <h3><?= number_format($stats['total_scans'] ?? 0) ?></h3>
                <p>إجمالي عمليات المسح</p>
            </div>
        </div>
    </div>
    
    <!-- Recent QR Codes -->
    <div class="section">
        <h2>أحدث رموز QR</h2>
        <div class="table-container">
            <table class="data-table">
                <thead>
                    <tr>
                        <th>الكود</th>
                        <th>العنوان</th>
                        <th>النوع</th>
                        <th>عدد المسحات</th>
                        <th>الحالة</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php if (empty($recentQRCodes)): ?>
                        <tr>
                            <td colspan="6" class="text-center">لا توجد رموز QR</td>
                        </tr>
                    <?php else: ?>
                        <?php foreach ($recentQRCodes as $qr): ?>
                            <tr>
                                <td><code><?= Security::sanitizeOutput($qr['short_code']) ?></code></td>
                                <td><?= Security::sanitizeOutput($qr['title']) ?></td>
                                <td><?= Security::sanitizeOutput($qr['target_type']) ?></td>
                                <td><?= number_format($qr['scan_count']) ?></td>
                                <td>
                                    <span class="badge <?= $qr['is_active'] ? 'badge-success' : 'badge-danger' ?>">
                                        <?= $qr['is_active'] ? 'نشط' : 'غير نشط' ?>
                                    </span>
                                </td>
                                <td>
                                    <a href="<?= Core\Helpers::url('qr/view.php?id=' . $qr['id']) ?>" class="btn btn-sm btn-primary">عرض</a>
                                    <?php if ($auth->hasPermission('qr.edit')): ?>
                                        <a href="<?= Core\Helpers::url('qr/edit.php?id=' . $qr['id']) ?>" class="btn btn-sm btn-secondary">تعديل</a>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>
    </div>
</div>

<?php include 'includes/footer.php'; ?>
