<?php
/**
 * Installation Script
 * Run this file once to set up the database
 */

error_reporting(E_ALL);
ini_set('display_errors', 1);

// Check if already installed
if (file_exists(__DIR__ . '/../.installed')) {
    die('System is already installed. Delete .installed file to reinstall.');
}

// Load Autoloader (needed for Helpers class)
require_once __DIR__ . '/../core/Autoloader.php';

use Core\Helpers;

?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تثبيت النظام - QR Code Management System</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            max-width: 800px;
            margin: 50px auto;
            padding: 20px;
            background: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 8px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        h1 {
            color: #007bff;
        }
        .form-group {
            margin-bottom: 20px;
        }
        label {
            display: block;
            margin-bottom: 5px;
            font-weight: bold;
        }
        input, select {
            width: 100%;
            padding: 10px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }
        button {
            background: #007bff;
            color: white;
            padding: 12px 24px;
            border: none;
            border-radius: 4px;
            cursor: pointer;
            font-size: 16px;
        }
        button:hover {
            background: #0056b3;
        }
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
        .success {
            background: #d4edda;
            color: #155724;
            padding: 15px;
            border-radius: 4px;
            margin-bottom: 20px;
        }
    </style>
</head>
<body>
    <div class="container">
        <h1>تثبيت نظام إدارة رموز QR</h1>
        
        <?php
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $dbHost = $_POST['db_host'] ?? 'localhost';
            $dbName = $_POST['db_name'] ?? '';
            $dbUser = $_POST['db_user'] ?? '';
            $dbPass = $_POST['db_pass'] ?? '';
            $baseUrl = $_POST['base_url'] ?? '';
            
            if (empty($dbName) || empty($dbUser) || empty($baseUrl)) {
                echo '<div class="error">جميع الحقول مطلوبة</div>';
            } else {
                try {
                    // Test database connection
                    $pdo = new PDO(
                        "mysql:host={$dbHost};charset=utf8mb4",
                        $dbUser,
                        $dbPass,
                        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
                    );
                    
                    // Create database if not exists
                    $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$dbName}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
                    $pdo->exec("USE `{$dbName}`");
                    
                    // Read and execute schema
                    $schema = file_get_contents(__DIR__ . '/../database/schema.sql');
                    
                    // Remove CREATE DATABASE and USE statements
                    $schema = preg_replace('/CREATE DATABASE.*?;/i', '', $schema);
                    $schema = preg_replace('/USE.*?;/i', '', $schema);
                    
                    // Execute schema
                    $statements = explode(';', $schema);
                    foreach ($statements as $statement) {
                        $statement = trim($statement);
                        if (!empty($statement)) {
                            $pdo->exec($statement);
                        }
                    }
                    
                    // Create config file
                    $configContent = "<?php\n";
                    $configContent .= "return [\n";
                    $configContent .= "    'host' => '{$dbHost}',\n";
                    $configContent .= "    'dbname' => '{$dbName}',\n";
                    $configContent .= "    'username' => '{$dbUser}',\n";
                    $configContent .= "    'password' => " . var_export($dbPass, true) . ",\n";
                    $configContent .= "    'charset' => 'utf8mb4',\n";
                    $configContent .= "    'options' => [\n";
                    $configContent .= "        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,\n";
                    $configContent .= "        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,\n";
                    $configContent .= "        PDO::ATTR_EMULATE_PREPARES => false,\n";
                    $configContent .= "        PDO::MYSQL_ATTR_INIT_COMMAND => \"SET NAMES utf8mb4 COLLATE utf8mb4_unicode_ci\"\n";
                    $configContent .= "    ]\n";
                    $configContent .= "];\n";
                    
                    file_put_contents(__DIR__ . '/../config/database.php', $configContent);
                    
                    // Update app config
                    $appConfig = file_get_contents(__DIR__ . '/../config/app.php');
                    $appConfig = preg_replace(
                        "/'base_url' => getenv\('BASE_URL'\) \?: '[^']*'/",
                        "'base_url' => '{$baseUrl}'",
                        $appConfig
                    );
                    file_put_contents(__DIR__ . '/../config/app.php', $appConfig);
                    
                    // Create uploads directories
                    $dirs = [
                        __DIR__ . '/../uploads',
                        __DIR__ . '/../uploads/qr_codes',
                        __DIR__ . '/../uploads/products',
                        __DIR__ . '/../uploads/datasheets'
                    ];
                    
                    foreach ($dirs as $dir) {
                        if (!is_dir($dir)) {
                            mkdir($dir, 0755, true);
                        }
                    }
                    
                    // Create .installed file
                    file_put_contents(__DIR__ . '/../.installed', date('Y-m-d H:i:s'));
                    
                    echo '<div class="success">تم التثبيت بنجاح!</div>';
                    echo '<p><strong>بيانات تسجيل الدخول الافتراضية:</strong></p>';
                    echo '<ul>';
                    echo '<li>اسم المستخدم: <strong>admin</strong></li>';
                    echo '<li>كلمة المرور: <strong>admin123</strong></li>';
                    echo '</ul>';
                    echo '<p><strong>⚠️ مهم جداً:</strong> قم بتغيير كلمة المرور فوراً بعد تسجيل الدخول!</p>';
                    echo '<p><a href="' . Helpers::url('login.php') . '">اضغط هنا للدخول إلى النظام</a></p>';
                    
                } catch (PDOException $e) {
                    echo '<div class="error">خطأ في قاعدة البيانات: ' . htmlspecialchars($e->getMessage()) . '</div>';
                } catch (Exception $e) {
                    echo '<div class="error">خطأ: ' . htmlspecialchars($e->getMessage()) . '</div>';
                }
            }
        }
        
        if ($_SERVER['REQUEST_METHOD'] !== 'POST' || isset($e)) {
        ?>
        
        <form method="POST">
            <div class="form-group">
                <label for="db_host">اسم الخادم:</label>
                <input type="text" id="db_host" name="db_host" value="localhost" required>
            </div>
            
            <div class="form-group">
                <label for="db_name">اسم قاعدة البيانات:</label>
                <input type="text" id="db_name" name="db_name" required>
            </div>
            
            <div class="form-group">
                <label for="db_user">اسم المستخدم:</label>
                <input type="text" id="db_user" name="db_user" required>
            </div>
            
            <div class="form-group">
                <label for="db_pass">كلمة المرور:</label>
                <input type="password" id="db_pass" name="db_pass">
            </div>
            
            <div class="form-group">
                <label for="base_url">رابط الموقع (Base URL):</label>
                <input type="url" id="base_url" name="base_url" placeholder="https://yourdomain.com" required>
                <small>مثال: https://qr.yourdomain.com أو http://localhost/qr</small>
            </div>
            
            <button type="submit">بدء التثبيت</button>
        </form>
        
        <?php } ?>
    </div>
</body>
</html>
