<?php
/**
 * List QR Codes
 */

require_once __DIR__ . '/../core/Autoloader.php';

use Core\Auth;
use Core\QRCode;
use Core\Security;

$auth = new Auth();
$auth->requirePermission('qr.view');

$qrHandler = new QRCode();
$user = $auth->user();

// Get filters
$page = max(1, (int)($_GET['page'] ?? 1));
$perPage = 20;
$filters = [];

if (!$auth->hasPermission('*')) {
    $filters['branch_id'] = $user['branch_id'];
}

if (!empty($_GET['search'])) {
    $filters['search'] = $_GET['search'];
}

if (!empty($_GET['target_type'])) {
    $filters['target_type'] = $_GET['target_type'];
}

if (isset($_GET['is_active'])) {
    $filters['is_active'] = (int)$_GET['is_active'];
}

$qrCodes = $qrHandler->list($filters, $page, $perPage);

$pageTitle = 'قائمة رموز QR';
include '../includes/header.php';
?>

<div class="page-header">
    <h1>قائمة رموز QR</h1>
    <?php if ($auth->hasPermission('qr.create')): ?>
        <a href="<?= Core\Helpers::url('qr/create.php') ?>" class="btn btn-primary">إنشاء رمز QR جديد</a>
    <?php endif; ?>
</div>

<div class="filters-card">
    <form method="GET" class="filter-form">
        <div class="form-group">
            <input type="text" name="search" placeholder="بحث..." value="<?= Security::sanitizeOutput($_GET['search'] ?? '') ?>">
        </div>
        <div class="form-group">
            <select name="target_type">
                <option value="">جميع الأنواع</option>
                <option value="product" <?= ($_GET['target_type'] ?? '') == 'product' ? 'selected' : '' ?>>منتج</option>
                <option value="warehouse" <?= ($_GET['target_type'] ?? '') == 'warehouse' ? 'selected' : '' ?>>مخزن</option>
                <option value="invoice" <?= ($_GET['target_type'] ?? '') == 'invoice' ? 'selected' : '' ?>>فاتورة</option>
                <option value="warranty" <?= ($_GET['target_type'] ?? '') == 'warranty' ? 'selected' : '' ?>>ضمان</option>
                <option value="custom" <?= ($_GET['target_type'] ?? '') == 'custom' ? 'selected' : '' ?>>مخصص</option>
            </select>
        </div>
        <div class="form-group">
            <select name="is_active">
                <option value="">جميع الحالات</option>
                <option value="1" <?= ($_GET['is_active'] ?? '') === '1' ? 'selected' : '' ?>>نشط</option>
                <option value="0" <?= ($_GET['is_active'] ?? '') === '0' ? 'selected' : '' ?>>غير نشط</option>
            </select>
        </div>
        <button type="submit" class="btn btn-secondary">بحث</button>
        <a href="<?= Core\Helpers::url('qr/list.php') ?>" class="btn btn-secondary">إعادة تعيين</a>
    </form>
</div>

<div class="table-container">
    <table class="data-table">
        <thead>
            <tr>
                <th>الكود</th>
                <th>العنوان</th>
                <th>النوع</th>
                <th>المنتج</th>
                <th>عدد المسحات</th>
                <th>الحالة</th>
                <th>الإجراءات</th>
            </tr>
        </thead>
        <tbody>
            <?php if (empty($qrCodes)): ?>
                <tr>
                    <td colspan="7" class="text-center">لا توجد رموز QR</td>
                </tr>
            <?php else: ?>
                <?php foreach ($qrCodes as $qr): ?>
                    <tr>
                        <td><code><?= Security::sanitizeOutput($qr['short_code']) ?></code></td>
                        <td><?= Security::sanitizeOutput($qr['title']) ?></td>
                        <td><?= Security::sanitizeOutput($qr['target_type']) ?></td>
                        <td><?= Security::sanitizeOutput($qr['product_name'] ?? '-') ?></td>
                        <td><?= number_format($qr['scan_count']) ?></td>
                        <td>
                            <span class="badge <?= $qr['is_active'] ? 'badge-success' : 'badge-danger' ?>">
                                <?= $qr['is_active'] ? 'نشط' : 'غير نشط' ?>
                            </span>
                        </td>
                        <td>
                            <a href="<?= Core\Helpers::url('qr/view.php?id=' . $qr['id']) ?>" class="btn btn-sm btn-primary">عرض</a>
                            <?php if ($auth->hasPermission('qr.edit')): ?>
                                <a href="<?= Core\Helpers::url('qr/edit.php?id=' . $qr['id']) ?>" class="btn btn-sm btn-secondary">تعديل</a>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            <?php endif; ?>
        </tbody>
    </table>
</div>

<?php include '../includes/footer.php'; ?>
