<?php
/**
 * QR Code Redirect Handler
 */

require_once __DIR__ . '/core/Autoloader.php';

use Core\QRCode;
use Core\Security;

// Get short code
$shortCode = $_GET['code'] ?? '';

if (empty($shortCode)) {
    Core\Helpers::redirect('404.php');
}

// Initialize QR code handler
$qrHandler = new QRCode();

// Check password protection
$qr = $qrHandler->getByShortCode($shortCode);

if ($qr && $qr['password_protected']) {
    // Check if password is already verified in session
    if (!isset($_SESSION['qr_verified_' . $shortCode])) {
        // Show password form
        if ($_SERVER['REQUEST_METHOD'] === 'POST') {
            $password = $_POST['password'] ?? '';
            if (Security::verifyPassword($password, $qr['password_hash'])) {
                $_SESSION['qr_verified_' . $shortCode] = true;
                Core\Helpers::redirect('redirect.php?code=' . $shortCode);
            } else {
                $error = 'Invalid password';
            }
        }
        ?>
        <!DOCTYPE html>
        <html lang="ar" dir="rtl">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>QR Code - Password Required</title>
            <style>
                body {
                    font-family: Arial, sans-serif;
                    display: flex;
                    justify-content: center;
                    align-items: center;
                    min-height: 100vh;
                    margin: 0;
                    background: #f5f5f5;
                }
                .container {
                    background: white;
                    padding: 40px;
                    border-radius: 8px;
                    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
                    max-width: 400px;
                    width: 100%;
                }
                h1 {
                    margin-top: 0;
                    color: #333;
                }
                .form-group {
                    margin-bottom: 20px;
                }
                label {
                    display: block;
                    margin-bottom: 5px;
                    color: #555;
                }
                input[type="password"] {
                    width: 100%;
                    padding: 10px;
                    border: 1px solid #ddd;
                    border-radius: 4px;
                    font-size: 16px;
                    box-sizing: border-box;
                }
                button {
                    width: 100%;
                    padding: 12px;
                    background: #007bff;
                    color: white;
                    border: none;
                    border-radius: 4px;
                    font-size: 16px;
                    cursor: pointer;
                }
                button:hover {
                    background: #0056b3;
                }
                .error {
                    color: #d32f2f;
                    margin-bottom: 15px;
                    padding: 10px;
                    background: #ffebee;
                    border-radius: 4px;
                }
            </style>
        </head>
        <body>
            <div class="container">
                <h1>QR Code محمي بكلمة مرور</h1>
                <?php if (isset($error)): ?>
                    <div class="error"><?= Security::sanitizeOutput($error) ?></div>
                <?php endif; ?>
                <form method="POST">
                    <div class="form-group">
                        <label for="password">كلمة المرور:</label>
                        <input type="password" id="password" name="password" required autofocus>
                    </div>
                    <button type="submit">دخول</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Get request data for redirect rules
$requestData = [
    'ip' => Security::getClientIP(),
    'user_agent' => $_SERVER['HTTP_USER_AGENT'] ?? '',
    'device_type' => Security::getDeviceType($_SERVER['HTTP_USER_AGENT'] ?? ''),
    'country' => $_GET['country'] ?? null, // Could be enhanced with GeoIP
    'city' => $_GET['city'] ?? null
];

// Handle redirect
$result = $qrHandler->handleRedirect($shortCode, $requestData);

if (isset($result['error'])) {
    // Handle errors (expired, disabled, etc.)
    Core\Helpers::redirect('error.php?type=' . urlencode($result['error']));
}

// Redirect to target URL
header('Location: ' . $result['redirect']);
exit;
