<?php
/**
 * Reset Admin Password Script
 * Run this file once to reset the admin password
 */

require_once __DIR__ . '/core/Autoloader.php';

use Core\Database;

$db = Database::getInstance();

// Generate new password hash for 'admin123'
$newPasswordHash = password_hash('admin123', PASSWORD_BCRYPT, ['cost' => 12]);

try {
    // Update admin password
    $db->query(
        "UPDATE users SET password = ?, login_attempts = 0, locked_until = NULL WHERE username = 'admin'",
        [$newPasswordHash]
    );
    
    echo "✅ تم تحديث كلمة مرور المستخدم 'admin' بنجاح!\n\n";
    echo "بيانات تسجيل الدخول:\n";
    echo "اسم المستخدم: admin\n";
    echo "كلمة المرور: admin123\n\n";
    echo "⚠️ مهم: قم بتغيير كلمة المرور بعد تسجيل الدخول!\n";
    echo "⚠️ احذف هذا الملف (reset_password.php) بعد التأكد من تسجيل الدخول!\n";
    
} catch (Exception $e) {
    echo "❌ خطأ: " . $e->getMessage() . "\n";
    echo "تأكد من أن قاعدة البيانات موجودة وأن المستخدم 'admin' موجود.\n";
}
